<!DOCTYPE html>
<html>
% include('header.tpl', title='A study of the perception of lettershapes')

<body>
    <div class="container">
      <h1>User questionnaire</h1>
      <p>Please answer all of the following questions and click the 'Next' button at the end of the page. 
      </p><br>
      <form id="user_form" action="./intro" method='post'>
        <fieldset>        
        <legend>Personal information</legend>
          <p><input name='prolificID' type="text" placeholder="Your prolific ID" required></p>
          <p><input name='age' type="number" placeholder="Your age" min="18" max="99" required></p>
        
          <p>
          <input required name='gender' type="radio" value="F" id='gender_F'><label for = "gender_F">Female</label>
          <input required name='gender' type="radio" value="M" id='gender_M'><label for = "gender_M">Male</label>
          <input required name='gender' type="radio" value="N" id='gender_N'><label for = "gender_N">Prefer not to specify</label>
          </p>

          <p class='question'>Do you use glasses or contact lenses for on-screen reading right now?<br>
          <input required name='glasses' type="radio" value='1' id="glasses_Y"><label for = "glasses_Y">Yes</label>
          <input required name='glasses' type="radio" value='0' id="glasses_N"><label for = "glasses_N">No</label>
          <input required name='glasses' type="radio" value="N" id='glasses_F'><label for = "glasses_N">Prefer not to specify</label>
          </p>

          <p class='question'>Do you see everything sharp when reading on this screen?<br>
          <input required  name='sharp' type="radio" value='1' id='sharp_Y'><label for = "sharp_Y">Yes</label>
          <input required  name='sharp' type="radio" value='0' id='sharp_N'><label for = "sharp_N">No</label>
          <input required  name='sharp' type="radio" value='N' id='sharp_F'><label for = "sharp_F">Prefer not to specify</label>
          </p>

          <p class='question'>Are you dyslexic or do you have trouble reading?<br>
          <input required  name='dyslexic' type="radio" value='1' id='dyslexic_Y'><label for = "dyslexic_Y">Yes</label>
          <input required  name='dyslexic' type="radio" value='0' id='dyslexic_N'><label for = "dyslexic_N">No</label>
          <input required  name='dyslexic' type="radio" value='N' id='dyslexic_F'><label for = "dyslexic_F">Prefer not to specify</label>
          </p>
        </fieldset>

        <fieldset>
        <legend>Previous experience with typefaces</legend>
            <p class='question'>Have you ever designed a typeface?<br>
            <input required  name='fontDesigned' type="radio" value='1' id='designed_Y'><label for = "designed_Y">Yes</label>
            <input required  name='fontDesigned' type="radio" value='0' id='designed_N'><label for = "designed_N">No</label>
            <input required  name='fontDesigned' type="radio" value='N' id='designed_F'><label for = "designed_F">Prefer not to specify</label>
            </p>
            <p class='question'>Have you ever licensed a font?<br>
            <input required  name='fontLicensed' type="radio" value='1' id='licensed_Y'><label for = "licensed_Y">Yes</label>
            <input required  name='fontLicensed' type="radio" value='0' id='licensed_N'><label for = "licensed_N">No</label>
            <input required  name='fontLicensed' type="radio" value='N' id='licensed_F'><label for = "licensed_F">Prefer not to specify</label>
            </p>
            <p class='question'>Have you ever downloaded a font?<br>
            <input required  name='fontDownloaded' type="radio" value='1' id='downloaded_Y'><label for = "downloaded_Y">Yes</label>
            <input required  name='fontDownloaded' type="radio" value='0' id='downloaded_N'><label for = "downloaded_N">No</label>
            <input required  name='fontDownloaded' type="radio" value='N' id='downloaded_F'><label for = "downloaded_F">Prefer not to specify</label>
            </p>
        </fieldset>

        <input type="hidden" name="dpr" id="dpr" value='-1'>
        <input type="hidden" name="screen_x" id="screen_x" value='-1'>
        <input type="hidden" name="screen_y" id="screen_y" value='-1'>
        <input type="hidden" name="browser_width" id="browser_width" value='-1'>
        <input type="hidden" name="browser_height" id="browser_height" value='-1'>
        <input type="hidden" name="browser" id="browser" value='-1'>
        <input type="hidden" name="start_time" id="start_time" value='-1'>

        <input type="submit" value=" N E X T ">

      </form>


    </div>
<!-- <script src="http://code.jquery.com/jquery-1.10.2.min.js"></script> -->

    <script src='/assets/js/jquery-1.11.3.min.js'></script>

    <script>
      if(window.devicePixelRatio !== undefined) { dpr = window.devicePixelRatio; } 
      else { dpr = 1; }

      $("#dpr").attr("value", dpr);
      $("#screen_x").attr("value", window.screen.width);
      $("#screen_y").attr("value", window.screen.height);
      $("#browser").attr("value", navigator.userAgent);

      $("#browser_width").attr("value", window.innerWidth);
      $("#browser_height").attr("value", window.innerHeight);

      var startTime = new Date().toISOString().slice(0, 19).replace('T', ' ');
      $("#start_time").attr("value", startTime);

    </script>

% include('footer.tpl')

</body>
</html>
